﻿Imports System.Diagnostics
Imports System.Threading
Imports System.IO
Imports System.Configuration

'
' Programed by Christopher David Zenzel
'
' NOAAPORT GIS Tools for Windows
' Requires: Microsoft .NET 4.0 Framework
'
' Licensed as part of the NOAAPORT project. Please keep the credit lines.
'
' Credit:
' Christopher Zenzel            GIS Tool Programmer for Windows (GUI)
' Jose Nieves                   NOAAPORT Project
' NOAAPORT Project Contributers They made the project the best!
'
' Version 1.0 Alpha
'

Public Class frmMain
    Public sat_gis As String = "win_gis/nbspsatgis.exe"
    Public rad_gis As String = "win_gis/nbspradgis.exe"
    Public unz_gis As String = "win_gis/nbspunz.exe"

    Private Sub rbWindows_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles rbWindows.CheckedChanged
        If rbWindows.Checked Then
            sat_gis = "win_gis/nbspsatgis.exe"
            rad_gis = "win_gis/nbspradgis.exe"
            unz_gis = "win_gis/nbspunz.exe"
            appendStatus("Platform Selected: Windows")
            If Not File.Exists("win_gis/nbspunz.exe") Or Not File.Exists("win_gis/nbspradgis.exe") Or Not File.Exists("win_gis/nbspsatgis.exe") Then
                appendStatus("Error: The tools for this platform have not been detected in the win_gis directory in the program root.")
            End If
        End If
    End Sub

    Private Sub rbLinux_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles rbLinux.CheckedChanged
        If rbLinux.Checked Then
            sat_gis = "nix_gis/nbspsatgis"
            rad_gis = "nix_gis/nbspradgis"
            unz_gis = "nix_gis/nbspunz"
            appendStatus("Platform Selected: Linux/Mac/*nix")
            If Not File.Exists("nix_gis/nbspunz") Or Not File.Exists("nix_gis/nbspradgis") Or Not File.Exists("nix_gis/nbspsatgis") Then
                appendStatus("Error: The tools for this platform have not been detected in the nix_gis directory in the program root.")
            End If
        End If
    End Sub

    Private Sub btnUncompress_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUncompress.Click
        Dim dg As DialogResult = OpenFileDialog1.ShowDialog()
        Dim strFileToOpen = OpenFileDialog1.FileName()
        If dg = Windows.Forms.DialogResult.Cancel Then
            Return
        End If
        SaveFileDialog1.Filter = ""
        dg = SaveFileDialog1.ShowDialog()
        Dim strFileToSave = SaveFileDialog1.FileName()
        If dg = Windows.Forms.DialogResult.Cancel Then
            Return
        End If
        Dim oargs As String = ""
        If rbRad.Checked Then
            oargs = "-C "
        End If
        Dim strUNC As String = RunProcess(unz_gis, oargs + " -o """ + strFileToSave + """ """ + strFileToOpen + """", "Finished Uncompressing " + strFileToSave)
    End Sub

    Public Function RunProcess(ByVal strApp As String, ByVal strArguments As String, ByVal strFinish As String) As String
        Dim t As Thread = New Thread(New ThreadStart(Sub()
                                                         Dim p As New Process()
                                                         p.StartInfo.FileName = strApp
                                                         p.StartInfo.Arguments = strArguments
                                                         p.StartInfo.RedirectStandardOutput = True
                                                         p.StartInfo.UseShellExecute = False
                                                         p.StartInfo.CreateNoWindow = True
                                                         p.Start()
                                                         p.WaitForExit()
                                                         Me.Invoke(Sub()
                                                                       appendStatus(strFinish)
                                                                   End Sub)
                                                     End Sub
        ))
        t.Start()
        Return "S"
    End Function

    Private Sub appendStatus(ByVal status As String)
        If txtActivity.Lines.Count > 30 Then
            txtActivity.Text = ""
        End If
        txtActivity.Text = txtActivity.Text + status + vbNewLine
    End Sub

    Private Sub btnASCII_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnASCII.Click
        Dim dg As DialogResult = OpenFileDialog1.ShowDialog()
        Dim strToOpen As String = OpenFileDialog1.FileName
        If dg = Windows.Forms.DialogResult.Cancel Then
            Return
        End If
        SaveFileDialog1.Filter = "ASCII Grid Files (*.asc)|*.asc"
        dg = SaveFileDialog1.ShowDialog()
        Dim strToSave As String = SaveFileDialog1.FileName
        If dg = Windows.Forms.DialogResult.Cancel Then
            Return
        End If

        Dim strArgs As String = "-a """ + strToSave + """ """ + strToOpen + """"
        Dim strOutput As String = ""

        If rbSat.Checked Then
            strOutput = RunProcess(sat_gis, strArgs, "Finished converting " + strToOpen + " to " + strToSave)
        ElseIf rbRad.Checked Then
            strOutput = RunProcess(rad_gis, strArgs, "Finished converting " + strToOpen + " to " + strToSave)
        End If

        strOutput = ""
    End Sub

    Private Sub btnShapefile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnShapefile.Click
        Dim dg As DialogResult = OpenFileDialog1.ShowDialog()
        If dg = Windows.Forms.DialogResult.Cancel Then
            Return
        End If
        Dim strToOpen As String = OpenFileDialog1.FileName
        SaveFileDialog1.Filter = "Shapefiles (*.shp)|*.shp"
        dg = SaveFileDialog1.ShowDialog()
        If dg = Windows.Forms.DialogResult.Cancel Then
            Return
        End If
        Dim strToSave As String = SaveFileDialog1.FileName

        Dim strArgs As String = "-p """ + strToSave + """ """ + strToOpen + """"
        Dim strOutput As String = ""

        If rbSat.Checked Then
            strOutput = RunProcess(sat_gis, strArgs, "Finished converting " + strToOpen + " to " + strToSave)
        ElseIf rbRad.Checked Then
            strOutput = RunProcess(rad_gis, strArgs, "Finished converting " + strToOpen + " to " + strToSave)
        End If

        strOutput = ""
    End Sub

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim def_platform As String = "win"

        appendStatus("Welcome to Noaaport GIS Tools")
        appendStatus("By Christopher Zenzel, Jose Nieves, NBSP/iNoaaport")

        Try
            def_platform = ConfigurationManager.AppSettings("platform")
            def_platform = def_platform.ToLower()
        Catch ex As Exception
            def_platform = "win"
        End Try

        If def_platform = "win" Then
            rbWindows.Checked = True
        ElseIf def_platform = "nix" Then
            rbLinux.Checked = True
        Else
            rbWindows.Checked = True
        End If
    End Sub
End Class
